{include file="left.tpl"}

<script>
	jQuery(document).ready(function($)
	{
		load_users();

		$('#search_login').keydown(function(event)
		{
			if(event.which == 13 && !event.shiftKey)
			{
				event.preventDefault();

				search_user('{start}');
			}
		});
	});

	function change_group(group)
	{
		location.href = '../users?group='+group+'&page=1';
	}

	function search_user()
	{
		login = encodeURIComponent($('#search_login').val());

		if(login == '')
		{
			$('.pages-list').show();

			load_users();

			return false;
		}
		
		$.ajax({
			type: 'POST',
			url: '../ajax/actions.php',
			data: 'phpaction=1&token='+$('#token').val()+'&search_login=1&login='+login+'&group='+encodeURIComponent($('#groups').val()),
			success: function(data)
			{
				$('.pages-list').hide();

				$('#users').html(data+'<div class="clear"></div>');
			}
		});
	}

	function load_users()
	{
		$.ajax({
			type: 'POST',
			url: '../ajax/actions.php',
			data: 'phpaction=1&token='+$('#token').val()+'&load_users=1&start={start}&group='+encodeURIComponent($('#groups').val()),
			success: function(data)
			{
				$('#users').html(data+'<div class="clear"></div>');
			}
		});
	}
</script>

<div class="content float-right">
	<div class="block">
		<div class="header">Поиск пользователей</div>
		<div class="block-content">
			<div class="form-input">
				<label for="groups">Группа</label>
				<select id="groups" onchange="change_group($(this).val())">{groups}</select>
			</div>
			<div class="form-input">
				<label for="class">Введите логин пользователя</label>
				<input type="text" id="search_login" name="search_login">
			</div>
			<div class="message-send">
				<div class="btn float-left" onclick="search_user()">Выполнить поиск</div>
			</div>

			<div class="clear"></div>
		</div>
	</div>

	<div class="block">
		<div class="header">Список пользователей</div>

		<center>
			<div class="pages-list">
				<div class="space">
				{func GetData:users("{start}", "{group}", "{limit}")}
				</div>
			</div>
		</center>

		<div class="block-content" id="users"><div class="bs-callout bs-callout-info bs-mini-info m-l-5 m-b-5 m-r-5 m-t-5"><p>Выполняется загрузка...</p></div></div>

		<center>
			<div class="pages-list">{pagination}</div>
		</center>
	</div>
</div>